#.2003 IBM_PROLOG_BEGIN_TAG 
#.2003 This is an automatically generated prolog. 
#.2003  
#.2003  
#.2003  
#.2003 Licensed Materials - Property of IBM 
#.2003  
#.2003 (C) COPYRIGHT International Business Machines Corp. 2003,2004 
#.2003 All Rights Reserved 
#.2003  
#.2003 US Government Users Restricted Rights - Use, duplication or 
#.2003 disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#.2003  
#.2003 IBM_PROLOG_END_TAG 
#
#
# @(#)33   1.30   src/csm/install/pkgdefs/Linux-RedHatEL-AS3-ppc64.pm.perl, setup, csm_rameh, rameh_base 7/6/04 06:04:25

#--------------------------------------------------------------------------------

=head3	Linux-RedHatEL-AS3-ppc64.pm.perl

        Package Definition File:   RedHatEL-AS 3 ppc

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package RedHatELAS3ppc64;

do "/opt/csm/install/pkgdefs/Linux.pm";

NodeUtils->messageFromCat(
                          'csmInstall.cat',
                          $::MSGMAPPATH,
                          'csminstall',
                          'V',
                          'IMsgLoading',
                          "/opt/csm/install/pkgdefs/Linux-RedHatEL-AS3-ppc64.pm"
                          );

my $_server_ = 'MgmtServer';
my $_node_   = 'MgdNode';

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{

    $::pkgdefs{DISTRO_NAME} = "Red Hat Enterprise Linux AS 3 PPC";
    $::pkgdefs{DISTRO_DISKLIST}   = "1 2 3";            # TO BE REMOVED
    $::pkgdefs{DISTRO_RPMDIR}     = "RedHat/RPMS";
    $::pkgdefs{DISTRO_UPDATESDIR} = "RedHat/Updates";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

                num                     = the number on the CD-ROM's label
                name                    = the text string describing the CD-ROM
                diskid_filename         = the filename to search to identify the disk
                                          - supportsw shell wildcards.
                diskid_searchstring     = the string to search for in diskid_filename
                                          - supports perl regular expressions


=cut

#--------------------------------------------------------------------------------

{
    my $dd_ref = [
        {
         num               => '1',
         name              => $::pkgdefs{DISTRO_NAME} . " (Update 1)",
         diskid_searchargs => {
                               file => '.discinfo',
                               num  => '1',
                               arch => 'ppc',
                               key  => '1065571970.028067',
                               rpm  => 'RedHat/Updates/redhat-release-3AS*',
         },
         diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
         diskid_target => 'RedHatEL-AS3-ppc64',
        },
        {
         num               => '2',
         name              => $::pkgdefs{DISTRO_NAME},
         diskid_searchargs => {
                               file => '.discinfo',
                               num  => '2',
                               arch => 'ppc',
                               key  => '1065571970.028067',
                               rpm  => '',
         },
         diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
         diskid_target => 'RedHatEL-AS3-ppc64',
        },
        {
         num  => '3',
         name => $::pkgdefs{DISTRO_NAME},

         diskid_searchargs => {
                               file => '.discinfo',
                               num  => '3',
                               arch => 'ppc',
                               key  => '1065571970.028067',
                               rpm  => '',
         },
         diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
         diskid_target => 'RedHatEL-AS3-ppc64',
        },
        {
         num               => '1',
         name              => $::pkgdefs{DISTRO_NAME} . "(Update 1) Extras CD",
         diskid_searchargs => {
                               file => '.discinfo',
                               num  => '1',
                               arch => 'ppc',
                               key  => '',
                               rpm  => 'images/iprdd.img',
         },
         diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
         diskid_target => 'RedHatEL-AS3-extra',
        },
        {
         num                  => '4',
         name                 => $::pkgdefs{DISTRO_NAME} . "(Update 2)",
         not_for_full_install => 'TRUE',

         diskid_searchargs => {
                               file => '.discinfo',
                               num  => '4',
                               arch => 'ppc',
                               key  => '1083779332.636875',
                               rpm  => 'RedHat/RPMS/sg3_utils-1.06-2.ppc.rpm',
         },
         diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
         diskid_target => 'RedHatEL-AS3-QU2-extra',
        }
        ];

    $::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------

=head3	Service Pack disks defination

        Notes:

=cut

#--------------------------------------------------------------------------------
{

    # set to distro disks

    $::pkgdefs{sp_disks}{QU1} = $::pkgdefs{distro_disks};
}

#--------------------------------------------------------------------------------
{
    my $qu2_ref = [
                   {
                    num  => '1',
                    name => $::pkgdefs{DISTRO_NAME} . " (Update 2)",
                    diskid_searchargs => {
                                    file => '.discinfo',
                                    num  => '1',
                                    arch => 'ppc',
                                    key  => '1083779332.636875',
                                    rpm => 'SRPMS/comps-3AS-0.20040505.src.rpm',
                    },
                    diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
                    diskid_target => 'RedHatEL-AS3-QU2',
                   },
                   {
                    num  => '2',
                    name => $::pkgdefs{DISTRO_NAME} . " (Update 2)",
                    diskid_searchargs => {
                                          file => '.discinfo',
                                          num  => '2',
                                          arch => 'ppc',
                                          key  => '1083779332.636875',
                                          rpm  => '',
                    },
                    diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
                    diskid_target => 'RedHatEL-AS3-QU2',
                   },
                   {
                    num  => '3',
                    name => $::pkgdefs{DISTRO_NAME} . " (Update 2)",
                    diskid_searchargs => {
                                          file => '.discinfo',
                                          num  => '3',
                                          arch => 'ppc',
                                          key  => '1083779332.636875',
                                          rpm  => '',
                    },
                    diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
                    diskid_target => 'RedHatEL-AS3-QU2',
                   },
                   {
                    num  => '4',
                    name => $::pkgdefs{DISTRO_NAME} . " (Update 2)",
                    diskid_searchargs => {
                                  file => '.discinfo',
                                  num  => '4',
                                  arch => 'ppc',
                                  key  => '1083779332.636875',
                                  rpm => 'RedHat/RPMS/sg3_utils-1.06-2.ppc.rpm',
                    },
                    diskid_searchprog => \&Linux::rhel3_diskid_match_prog,
                    diskid_target => 'RedHatEL-AS3-QU2',
                   },
                   ];

    $::pkgdefs{sp_disks}{QU2} = $qu2_ref;
}

#--------------------------------------------------------------------------------

=head3	opensrc_prereqs - Open Source Prereqs to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $opr_ref;

    # defaults
    $opr_ref{$_server_}{$::csm_version} = [
        'tftp-hpa',  'IBMJava2-JRE-ppc-1.4.1',
        'conserver', 'fping',
        'openCIMOM-0.8-1'
        ];

    $opr_ref{$_node_}{$::csm_version} = ['autoupdate'];

    # exceptions  - must follow the default assignments.
    $opr_ref{$_node_}{'1.2.0'} = [];

    $::pkgdefs{opensrc_prereqs} = $opr_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	rsct_packages - RSCT Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $rp_ref;

    # defaults
    $rp_ref{$_server_}{$::csm_version} =
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic', 'rsct.core.cimrm'];

    $rp_ref{$_node_}{$::csm_version} =
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic', 'rsct.core.cimrm'];

    # exceptions  - must follow the default assignments.
    # none
    $rp_ref{$_node_}{'1.2.0'} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];
    $rp_ref{$_node_}{'1.3.0'} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];
    $rp_ref{$_node_}{'1.3.1'} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];
    $rp_ref{$_node_}{'1.3.2'} = 
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.basic'];

    $::pkgdefs{rsct_packages} = $rp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_packages - CSM Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cp_ref;

    # defaults
    $cp_ref{$_server_}{$::csm_version} =
      ['csm.core', 'csm.dsh', 'csm.server', 'csm.diagnostics', 'csm.gui.dcem'];

    $cp_ref{$_node_}{$::csm_version} =
      ['csm.core', 'csm.client', 'csm.diagnostics'];

    # exceptions  - must follow the default assignments.
    $cp_ref{$_node_}{'1.2.0'} = ['csm.core', 'csm.client'];

    $::pkgdefs{csm_packages} = $cp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	director_packages - Director Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $dp_ref;

    # defaults
    $dp_ref{$_server_}{$::csm_version} = ['csm.director.agent'];
    $dp_ref{$_node_}{$::csm_version}   = ['csm.director.agent'];

    # exceptions  - must follow the default assignments.
    
    $dp_ref{$_node_}{'1.2.0'}   = [];
    $dp_ref{$_node_}{'1.3.0'}   = [];
    $dp_ref{$_node_}{'1.3.1'}   = [];
    $dp_ref{$_node_}{'1.3.2'}   = [];

    $::pkgdefs{director_packages} = $dp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	rsct_unpackages - RSCT Packages to uninstall

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $rup_ref;

    # defaults
    $rup_ref{$_server_}{$::csm_version} =
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.core.cimrm'];

    $rup_ref{$_node_}{$::csm_version} =
      ['src', 'rsct.core.utils', 'rsct.core', 'rsct.core.cimrm'];

    # exceptions  - must follow the default assignments.
    # none
    $rup_ref{$_node_}{'1.2.0'} = 
      ['src', 'rsct.core.utils', 'rsct.core'];
    $rup_ref{$_node_}{'1.3.0'} = 
      ['src', 'rsct.core.utils', 'rsct.core'];
    $rup_ref{$_node_}{'1.3.1'} = 
      ['src', 'rsct.core.utils', 'rsct.core'];
    $rup_ref{$_node_}{'1.3.2'} = 
      ['src', 'rsct.core.utils', 'rsct.core'];

    $::pkgdefs{rsct_unpackages} = $rup_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_unpackages - CSM Packages to uninstall	

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cup_ref;

    # defaults
    $cup_ref{$_server_}{$::csm_version} =
      ['csm.dsh', 'csm.server', 'csm.diagnostics', 'csm.gui.dcem'];

    $cup_ref{$_node_}{$::csm_version} =
      ['csm.core', 'csm.diagnostics', 'csm.client'];

    # exceptions  - must follow the default assignments.
    $cup_ref{$_node_}{'1.2.0'} = ['csm.core', 'csm.client'];

    $::pkgdefs{csm_unpackages} = $cup_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_uninstall_dirs - Directories to uninstall from the management server

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cud_ref;

    # defaults
    $cud_ref{$_server_}{$::csm_version} = ['/csminstall', '/cfmroot'];

    $cud_ref{$_node_}{$::csm_version} = [];

    # exceptions  - must follow the default assignments.
    # none

    $::pkgdefs{csm_uninstall_dirs} = $cud_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_nouninstall_pkgs - Packages to NOT uninstall

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $cuip_ref;

    # defaults
    $cuip_ref{$_server_}{$::csm_version} = ['csm.core'];

    $cuip_ref{$_node_}{$::csm_version} = [];

    # exceptions  - must follow the default assignments.
    # none

    $::pkgdefs{csm_nouninstall_pkgs} = $cuip_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	CSM binaries copied to /csminstall/csm directory

        Notes:

=cut

#--------------------------------------------------------------------------------

{
    my $cbin_ref;

    # defaults
    $cbin_ref{$::csm_version} = [
                                 '/opt/csm/csmbin/updatenode.client',
                                 '/opt/csm/csmbin/write_status',
                                 '/opt/csm/msgmaps/csmInstall.csminstall.map',
                                 '/opt/csm/pm/MessageUtils.pm',
                                 '/opt/csm/pm/NodeUtils.pm',
                                 '/opt/csm/pm/ArchiveUtils.pm',
                                 '/opt/csm/pm/InstallUtils.pm',
                                 '/opt/csm/pm/InstallKRB5Utils.pm',
                                 '/opt/csm/msgmaps/csmKRB5p.csmKRB5p_msg.map',
                                 '/opt/csm/pm/NetworkUtils.pm',
                                 '/opt/csm/pm/ServerUtils.pm',
                                 '/opt/csm/pm/CSMDefs.pm',
                                 '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
                                 '/opt/csm/csmbin/rmnode_client',
                                 '/opt/csm/bin/setupconsole',
                                 '/opt/csm/csmbin/makenode',
                                 '/opt/csm/csmbin/setbootdisk',
                                 '/opt/csm/csmbin/csmprereboot',
                                 '/opt/csm/csmbin/csmfirstboot',
                                 '/opt/csm/install/defs',
                                 '/opt/csm/install/pkgdefs',
                                 '/usr/sbin/rsct/cfg/ctsec.cfg',
                                 '/usr/sbin/rsct/bin/runact-api',
                                 '/opt/csm/csmbin/nodestatus.client'
                                 ];

    # exceptions  - must follow the default assignments.
    $cbin_ref{'1.2.0'} = [
                          '/opt/csm/csmbin/updatenode.client',
                          '/opt/csm/csmbin/write_status',
                          '/opt/csm/msgmaps/csmInstall.csminstall.map',
                          '/opt/csm/pm/MessageUtils.pm',
                          '/opt/csm/pm/NodeUtils.pm',
                          '/opt/csm/pm/ArchiveUtils.pm',
                          '/opt/csm/pm/InstallUtils.pm',
                          '/opt/csm/pm/NetworkUtils.pm',
                          '/opt/csm/pm/ServerUtils.pm',
                          '/opt/csm/pm/CSMDefs.pm',
                          '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
                          '/opt/csm/csmbin/rmnode_client',
                          '/opt/csm/bin/setupconsole',
                          '/opt/csm/csmbin/makenode',
                          '/opt/csm/csmbin/csmprereboot',
                          '/opt/csm/csmbin/csmfirstboot',
                          '/usr/bin/tftp',
                          '/opt/csm/install/defs',
                          '/opt/csm/install/pkgdefs'
                          ];

    $cbin_ref{'1.3.0'} = [
                          '/opt/csm/csmbin/updatenode.client',
                          '/opt/csm/csmbin/write_status',
                          '/opt/csm/msgmaps/csmInstall.csminstall.map',
                          '/opt/csm/pm/MessageUtils.pm',
                          '/opt/csm/pm/NodeUtils.pm',
                          '/opt/csm/pm/ArchiveUtils.pm',
                          '/opt/csm/pm/InstallUtils.pm',
                          '/opt/csm/pm/NetworkUtils.pm',
                          '/opt/csm/pm/ServerUtils.pm',
                          '/opt/csm/pm/CSMDefs.pm',
                          '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
                          '/opt/csm/csmbin/rmnode_client',
                          '/opt/csm/bin/setupconsole',
                          '/opt/csm/csmbin/makenode',
                          '/opt/csm/csmbin/csmprereboot',
                          '/opt/csm/csmbin/csmfirstboot',
                          '/usr/bin/tftp',
                          '/opt/csm/install/defs',
                          '/opt/csm/install/pkgdefs'
                          ];

    $cbin_ref{'1.3.1'} = [
                          '/opt/csm/csmbin/updatenode.client',
                          '/opt/csm/csmbin/write_status',
                          '/opt/csm/msgmaps/csmInstall.csminstall.map',
                          '/opt/csm/pm/MessageUtils.pm',
                          '/opt/csm/pm/NodeUtils.pm',
                          '/opt/csm/pm/ArchiveUtils.pm',
                          '/opt/csm/pm/InstallUtils.pm',
                          '/opt/csm/pm/NetworkUtils.pm',
                          '/opt/csm/pm/ServerUtils.pm',
                          '/opt/csm/pm/CSMDefs.pm',
                          '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
                          '/opt/csm/csmbin/rmnode_client',
                          '/opt/csm/bin/setupconsole',
                          '/opt/csm/csmbin/makenode',
                          '/opt/csm/csmbin/setbootdisk',
                          '/opt/csm/csmbin/csmprereboot',
                          '/opt/csm/csmbin/csmfirstboot',
                          '/usr/bin/tftp',
                          '/opt/csm/install/defs',
                          '/opt/csm/install/pkgdefs'
                          ];

    $cbin_ref{'1.3.2'} = [
                          '/opt/csm/csmbin/updatenode.client',
                          '/opt/csm/csmbin/write_status',
                          '/opt/csm/msgmaps/csmInstall.csminstall.map',
                          '/opt/csm/pm/MessageUtils.pm',
                          '/opt/csm/pm/NodeUtils.pm',
                          '/opt/csm/pm/ArchiveUtils.pm',
                          '/opt/csm/pm/InstallUtils.pm',
                          '/opt/csm/pm/NetworkUtils.pm',
                          '/opt/csm/pm/ServerUtils.pm',
                          '/opt/csm/pm/CSMDefs.pm',
                          '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
                          '/opt/csm/csmbin/rmnode_client',
                          '/opt/csm/bin/setupconsole',
                          '/opt/csm/csmbin/makenode',
                          '/opt/csm/csmbin/setbootdisk',
                          '/opt/csm/csmbin/csmprereboot',
                          '/opt/csm/csmbin/csmfirstboot',
                          '/opt/csm/install/defs',
                          '/opt/csm/install/pkgdefs',
                          '/usr/sbin/rsct/cfg/ctsec.cfg',
                          '/usr/sbin/rsct/bin/runact-api',
                          '/opt/csm/csmbin/nodestatus.client'
                          ];
    $::pkgdefs{csm_bin_copy_csm} = $cbin_ref{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	CSM binaries copied to /tftpboot directory

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $a_ref;

    # defaults
    $a_ref = [];

    # exceptions  - must follow the default assignments.
    # none

    $::pkgdefs{csm_bin_copy_tftpboot} = $a_ref;
}

#--------------------------------------------------------------------------------

=head3	os_prereqs - Operating System pre-requisites

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $osp_ref;

    $osp_ref{$_server_} = [
                           'perl-5*',           'nfs-utils-*',
                           'pdksh-*',           'dhcp-3*',
                           'rdist-6*',          'tcl-8.3*',
                           'tk-8.3*',           'expect-5.38*',
                           'XFree86-libs-4.3*', 'freetype-2.1*',
                           'compat-libstdc++-*'
                           ];

    $osp_ref{$_node_} = [
                         'perl-5*',            'nfs-utils-*',
                         'pdksh-*',            'rdist-6*',
                         'compat-libstdc++-*', 'perl-DB_File-*',
                         'sg3_utils-*'
                         ];

    $::pkgdefs{os_prereqs} = $osp_ref{$::mgmt_type};
}

1;    # end

